<?php

namespace App\Http\Controllers;

use App\Models\DirigeantsService;
use App\Http\Requests\StoreDirigeantsServiceRequest;
use App\Http\Requests\UpdateDirigeantsServiceRequest;
use App\Models\Demande;
use App\Services\VeriffService;
use App\Services\TwilioService;

class DirigeantsServiceController extends Controller
{
    protected $twilioService;
    protected $veriffService;
    public function __construct(VeriffService $veriffService,TwilioService $twilioService)
    {
        $this->twilioService = $twilioService;
        $this->veriffService = $veriffService;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreDirigeantsServiceRequest $request)
    {
        $demande = Demande::find($request->demande_id);
        if($demande){
            if($request->is_not_bce){
                $session = $this->veriffService->createSession();
                if(isset($session)){
                        // send SMS to GSM
                        $to = $request->GSM;
                        $link = $session['verification_url'];
                        // $message = "Cliquez ici pour vérifier votre compte : $link. Cela nous permettra de confirmer votre identité.\nAktly.";
                        $message = "Cliquez ici pour vérifier votre identité : $link.";
                        $this->twilioService->sendSms($to,$message);
                        $dirigeant = $demande->dirigeants()->create([
                            'surname' => $request->surname,
                            'givenName' => $request->givenName,
                            'GSM' => $request->GSM,
                            'veriff_session'=>$session['session_id'],
                            'veriff_url'=>$session['verification_url'],
                        ]);
                    }
               return response()->json($dirigeant->fresh());
            }else{
                $data = json_decode($demande->bce_data);
                $dirigeants = [];
                foreach($data->function as $dirigeant){
                    $dirigeants[] = [
                        'demande_id' => $request->demande_id,
                        'surname' => $dirigeant->person->surname,
                        'givenName' => $dirigeant->person->givenName,
                        'status' => 'accepté'
                    ];
                };
                    $created = $demande->dirigeants()->createMany($dirigeants);
                    return response()->json($created);
        
                }
                return response()->json(['message'=>'Dirigeants can\'t created !']);
            }else{
                return response()->json(['message'=>'Demande not found !']);
            }

    }

    /**
     * Display the specified resource.
     */
    public function show(DirigeantsService $dirigeantsService)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(DirigeantsService $dirigeantsService)
    {
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateDirigeantsServiceRequest $request, DirigeantsService $dirigeantsService)
    {

            DirigeantsService::where('id',$dirigeantsService->id)->update($request->all());
            // create veriff session
            $session = $this->veriffService->createSession();
            if($session['session_id']){
                $d = DirigeantsService::where('id',$dirigeantsService->id)->update(['veriff_session'=>$session['session_id'],'veriff_url'=>$session['verification_url']]);
                if($d){
                    // send SMS to GSM
                    $to = $request->GSM;
                    $link = $session['verification_url'];
                    // $message = "Cliquez ici pour vérifier votre compte : $link. Cela nous permettra de confirmer votre identité.\nAktly.";
                    $message = "Cliquez ici pour vérifier votre identité : $link.";
                    $this->twilioService->sendSms($to,$message);
                    return response()->json($d);
                }
            }else{
                return response()->json(['error'=>"Something want wrong !"]);
            }
        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DirigeantsService $dirigeantsService)
    {
        //
    }
}
