<?php

namespace App\Http\Controllers;

use App\Models\Demande;
use Illuminate\Http\Request;

class gestionDesPdsController extends Controller
{
    public function formulaire1(Request $request)
    {
        
        $demande_id = $request->query('demande_id');
        $data = Demande::find($demande_id);
        $langue = $data->langue_entreprise;
        $text1 = $this->wordwrap_alnum($data->pub_text);
        $text2 = $this->splitTextByLines($text1, 30);
        $data->pub_text = $text2;
        if ($langue == 'fr' && $data) {
            if ($request->query('download')) {
                return view('pdfs.fr.formulaire1', ['data' => json_decode($data->bce_data, true), 'download' => true, 'demande' => $data]);
            } else {
                return view('pdfs.fr.formulaire1', ['data' => json_decode($data->bce_data, true), 'demande' => $data]);
            }
        }else if($langue == 'nl' && $data){
            if($request->query('download')){
                return view('pdfs.nl.formulier1',['data' => json_decode($data->bce_data,true),'download'=>true, 'demande' => $data]); 
            }else{
                return view('pdfs.nl.formulier1',['data' => json_decode($data->bce_data,true), 'demande' => $data]);
            }
        } else {

        }
    }
    public function formulaire2(Request $request)
    {
        $demande_id = $request->query('demande_id');

        $data = Demande::find($demande_id);
        $langue = $data->langue_entreprise;
        if ($langue == 'fr' && $data) {
            if ($request->query('download')) {
                return view('pdfs.fr.formulaire2', ['data' => json_decode($data->bce_data, true), 'download' => true]);
            } else {
                return view('pdfs.fr.formulaire2', ['data' => json_decode($data->bce_data, true)]);
            }
        }else if($langue == 'nl' && $data){
            if($request->query('download')){
                return view('pdfs.nl.formulier2',['data' => json_decode($data->bce_data,true),'download'=>true]);
            }else{
                return view('pdfs.nl.formulier2',['data' => json_decode($data->bce_data,true)]);
            }
        } else {

        }
    }

    private function wordwrap_alnum($text, $limit = 80, $break = '<br>')
    {
         $text = str_replace(["\n"], "<br>", $text);
        // On divise par ligne (en gardant les \n)
        $lines = explode("<br>", $text);
        $wrappedText = '';

        foreach ($lines as $line) {
            // Traitement d'une ligne à la fois
            $words = preg_split('/(\s+)/u', $line, -1, PREG_SPLIT_DELIM_CAPTURE); // conserve les espaces
            $currentLine = '';
            $currentLength = 0;

            foreach ($words as $chunk) {
                // Pour les espaces, on les ajoute sans compter leur longueur
                if (preg_match('/^\s+$/u', $chunk)) {
                    $currentLine .= $chunk;
                    continue;
                }

                // Longueur visible du mot (on enlève les balises HTML et on gère les entités)
                $visibleChunk = html_entity_decode(strip_tags($chunk), ENT_QUOTES | ENT_HTML5, 'UTF-8');
                $chunkLength = mb_strlen($visibleChunk, 'UTF-8');

                if ($currentLength + $chunkLength > $limit) {
                    // Saut de ligne si dépasser la limite
                    $wrappedText .= rtrim($currentLine) . $break;
                    $currentLine = $chunk;
                    $currentLength = $chunkLength;
                } else {
                    $currentLine .= $chunk;
                    $currentLength += $chunkLength;
                }
            }

            // Ajouter la dernière partie de la ligne
            $wrappedText .= $currentLine . $break;
        }

        // Supprimer le dernier <br> ajouté inutilement
        return rtrim($wrappedText, $break);
    }




    private function splitTextByLines(string $text, int $maxLines = 25): array
    {
        // Découper le texte en lignes
        $lines = preg_split("/\r\n|\r|\n|<br>/i", $text);

        // Séparer selon le nombre de lignes
        $part1 = implode("<br>", array_slice($lines, 0, $maxLines));
        $part2 = implode("<br>", array_slice($lines, $maxLines));

        return [
            'part1' => $part1,
            'part2' => $part2,
        ];
    }

}
