<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Demande extends Model
{
    /** @use HasFactory<\Database\Factories\DemandeFactory> */
    use HasFactory;
    use HasUuids;
    // protected $fillable = ['bce_data', 'enterprise_number', 'langue','user_id'];
    protected $guarded = [];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($demande) {
            if (empty($demande->id)) {
                $demande->id = Str::uuid(); 
            }
        });
    }
    public $incrementing = false;
    protected $keyType = 'string';
    public function dirigeants()
    {
        return $this->hasMany(DirigeantsService::class,'demande_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function tickets()
    {
        return $this->hasMany(Ticket::class,'demande_id');
    }
    public function shareholders(){
        return $this->hasMany(ShareHolder::class,'demande_id');
    }
}
