<?php

namespace App\Services;

use App\Models\DirigeantsService;
use App\Models\ShareHolder;
use GuzzleHttp\Client;
use App\Models\AddressService;

class OpenAIService
{
    private $client;

    public function __construct()
    {
        $this->client = new Client([
            'base_uri' => 'https://api.openai.com/v1/',
            'headers' => [
                'Authorization' => 'Bearer ' . config('services.openai.api_key'),
                'Content-Type' => 'application/json',
            ]
        ]);
    }

    public function getChatCompletion($message, $model = 'gpt-4o')
    {
        try {
            $response = $this->client->post('chat/completions', [
                'json' => [
                    'model' => $model,
                    'messages' => [
                        ['role' => 'system', 'content' => $message]
                    ],
                ]
            ]);

            $data = json_decode($response->getBody(), true);
            return $data['choices'][0]['message']['content'] ?? null;

        } catch (\Exception $e) {
            \Log::error('Erreur API OpenAI : ' . $e->getMessage());
            return null;
        }
    }

    public function buildMessage($demande)
    {
        // Génération du prompt en fonction des services activés
        $sections = [];
        $msg = 'Formuler un  compte rendu d\'assemblé generale qui etait le ' . $demande->date_assemblee . ' voici les decisions : ';
        if ($demande['address_service']) {
            $AddressService = AddressService::where('demande_id', $demande->id)->first();
            $msg = '-Le siège social de la société a été transféré le ' . $demande->date_changement . ' de l’adresse située au ' . $AddressService->an_address . ' à la nouvelle adresse :' . $AddressService->nv_address; 
        }

        if ($demande['dirigeants_service']) {
            $nvDirigeatns = DirigeantsService::where('demande_id', $demande->id)->get();
            $oldDirigeants = [];
            $data = json_decode($demande->bce_data);
            foreach($data->function as $dirigeant){
                $oldDirigeants[] = [
                    'surname' => $dirigeant->person->surname,
                    'givenName' => $dirigeant->person->givenName,
                ];
            };

            $AddedDirigeants = array_filter($nvDirigeatns->toArray(), function($nvDirigeant) use ($oldDirigeants) {
                foreach ($oldDirigeants as $oldDirigeant) {
                    if ($nvDirigeant['surname'] === $oldDirigeant['surname'] && $nvDirigeant['givenName'] === $oldDirigeant['givenName']) {
                        return false;
                    }
                }
                return true;
            });

            if (!empty($AddedDirigeants)) {
                $msg .= '-nomination de ces personnes comme dirigeantsle ' . $demande->date_changement . '  : ';
                foreach ($AddedDirigeants as $dirigeant) {
                    $msg .= $dirigeant['surname'] . ' ' . $dirigeant['givenName'] . ', ';
                }
                $msg = rtrim($msg, ', ');
            }

            $RemovedDirigeants = array_filter($oldDirigeants, function($oldDirigeant) use ($nvDirigeatns) {
                foreach ($nvDirigeatns as $nvDirigeant) {
                    if ($oldDirigeant['surname'] === $nvDirigeant['surname'] && $oldDirigeant['givenName'] === $nvDirigeant['givenName']) {
                        return false;
                    }
                }
                return true;
            });
            if (!empty($RemovedDirigeants)) {
                $msg .= '-démission de ces personnes comme dirigeants le ' . $demande->date_changement . '  : ';
                foreach ($RemovedDirigeants as $dirigeant) {
                    $msg .= $dirigeant['surname'] . ' ' . $dirigeant['givenName'] . ', ';
                }
                $msg = rtrim($msg, ', ');
            }

        }

        if($demande['cession_parts_service']) {
            $msg .= '-Cession de parts le ' . $demande->date_changement . ' : ';
            $cession_parts = ShareHolder::where('demande_id', $demande->id)->get();
            $oldShareHolders = [];
            $newShareHolders = [];
            foreach ($cession_parts as $cession) {
                if($cession->is_origin == 1 && $cession->shares < $cession->shares_old) {
                    $oldShareHolders[] = [
                        'surname' => $cession->full_name,
                        'shares' => $cession->shares_old - $cession->shares  ,
                    ];
                }

                if($cession->is_origin == 1 && $cession->shares > $cession->shares_old) {
                    $newShareHolders[] = [
                        'surname' => $cession->full_name,
                        'shares' => $cession->shares,
                    ];
                }

                if($cession->is_origin == 0 && $cession->shares > 0) {
                    $newShareHolders[] = [
                        'surname' => $cession->full_name,
                        'shares' => $cession->shares,
                    ];
                }
            }
            foreach ($oldShareHolders as $cession) {
                $msg .= $cession['surname'] . ' cede ' . $cession['shares'] .  ', ';
            }
            foreach($newShareHolders as $cession) {
                $msg .= $cession['surname'] . ' recoit ' . $cession['shares'] .  ', ';
            }
            $msg = rtrim($msg, ', ');
        }
        
        $msg .= "Le text doit être clair  et mentionner la date pour chaque service et en langue " . $demande->langue_entreprise;
        return $msg;
    }
}