<?php

namespace App\Services;

use Twilio\Rest\Client;

class TwilioService
{
    protected $twilio;

    public function __construct()
    {
         $this->twilio = new Client(env('TWILIO_SID'), env('TWILIO_AUTH_TOKEN'));
    }

    public function sendSms($to, $message)
    {
        $phoneNumber = "+18777804236"; 
        return $this->twilio->messages->create($phoneNumber, [
           'from' => env('TWILIO_PHONE_NUMBER'),
           'body' => $message
        ]);
    }
}
