<?php
namespace App\Services;

use App\Http\Controllers\Controller;
use GuzzleHttp\Client;

class VeriffService{

    public function createSession()
    {
        // Initialize HTTP Client
        $client = new Client();
        $url = env('VERIFF_API_URL') . '/sessions';
        $apiKey = env('VERIFF_API_KEY');
        // $kboData = Session::get('api-data');
        // if(!$kboData){
        //     return redirect()->route('veriff.error_page');
        // }
        try {
            // Create Veriff session
            $response = $client->post($url, [
                'headers' => [
                    'X-AUTH-CLIENT' => $apiKey,
                    'Content-Type' => 'application/json',
                ],
            ]);

            $sessionData = json_decode($response->getBody(), true);

            // Get session ID and URL
            $sessionId = $sessionData['verification']['id'];
            $verificationUrl = $sessionData['verification']['url'];
            return $body = [
                'session_id' => $sessionId,
                'verification_url' => $verificationUrl
            ];

        } catch (\Exception $e) {
            return response()->json(['error' => 'Veriff API error: ' . $e->getMessage()], 500);
        }
    }
}
