'use strict';

require('../date/calendar.cjs');
const date_comparators = require('../date/comparators.cjs');
const vue = require('vue');
const date = require('@internationalized/date');
const Primitive_usePrimitiveElement = require('../Primitive/usePrimitiveElement.cjs');
const Primitive_Primitive = require('../Primitive/Primitive.cjs');
const shared_useKbd = require('../shared/useKbd.cjs');
const Calendar_CalendarRoot = require('./CalendarRoot.cjs');

const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  __name: "CalendarCellTrigger",
  props: {
    day: {},
    month: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(__props) {
    const props = __props;
    const kbd = shared_useKbd.useKbd();
    const rootContext = Calendar_CalendarRoot.injectCalendarRootContext();
    const { primitiveElement, currentElement } = Primitive_usePrimitiveElement.usePrimitiveElement();
    const dayValue = vue.computed(() => props.day.day.toLocaleString(rootContext.locale.value));
    const labelText = vue.computed(() => {
      return rootContext.formatter.custom(date_comparators.toDate(props.day), {
        weekday: "long",
        month: "long",
        day: "numeric",
        year: "numeric"
      });
    });
    const isDisabled = vue.computed(() => rootContext.isDateDisabled(props.day));
    const isUnavailable = vue.computed(
      () => rootContext.isDateUnavailable?.(props.day) ?? false
    );
    const isDateToday = vue.computed(() => {
      return date.isToday(props.day, date.getLocalTimeZone());
    });
    const isOutsideView = vue.computed(() => {
      return !date.isSameMonth(props.day, props.month);
    });
    const isOutsideVisibleView = vue.computed(
      () => rootContext.isOutsideVisibleView(props.day)
    );
    const isFocusedDate = vue.computed(() => {
      return !rootContext.disabled.value && date.isSameDay(props.day, rootContext.placeholder.value);
    });
    const isSelectedDate = vue.computed(() => rootContext.isDateSelected(props.day));
    const SELECTOR = "[data-reka-calendar-cell-trigger]:not([data-disabled]):not([data-outside-view]):not([data-outside-visible-view])";
    function changeDate(date) {
      if (rootContext.readonly.value)
        return;
      if (rootContext.isDateDisabled(date) || rootContext.isDateUnavailable?.(date))
        return;
      rootContext.onDateChange(date);
    }
    function handleClick() {
      changeDate(props.day);
    }
    function handleArrowKey(e) {
      e.preventDefault();
      e.stopPropagation();
      const parentElement = rootContext.parentElement.value;
      const allCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(SELECTOR)) : [];
      const index = allCollectionItems.indexOf(currentElement.value);
      let newIndex = index;
      const indexIncrementation = 7;
      const sign = rootContext.dir.value === "rtl" ? -1 : 1;
      switch (e.code) {
        case kbd.ARROW_RIGHT:
          newIndex += sign;
          break;
        case kbd.ARROW_LEFT:
          newIndex -= sign;
          break;
        case kbd.ARROW_UP:
          newIndex -= indexIncrementation;
          break;
        case kbd.ARROW_DOWN:
          newIndex += indexIncrementation;
          break;
        case kbd.ENTER:
        case kbd.SPACE_CODE:
          changeDate(props.day);
          return;
        default:
          return;
      }
      if (newIndex >= 0 && newIndex < allCollectionItems.length) {
        allCollectionItems[newIndex].focus();
        return;
      }
      if (newIndex < 0) {
        if (rootContext.isPrevButtonDisabled())
          return;
        rootContext.prevPage();
        vue.nextTick(() => {
          const newCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(SELECTOR)) : [];
          if (!rootContext.pagedNavigation.value) {
            const numberOfDays = date_comparators.getDaysInMonth(rootContext.placeholder.value);
            newCollectionItems[numberOfDays - Math.abs(newIndex)].focus();
            return;
          }
          newCollectionItems[newCollectionItems.length - Math.abs(newIndex)].focus();
        });
        return;
      }
      if (newIndex >= allCollectionItems.length) {
        if (rootContext.isNextButtonDisabled())
          return;
        rootContext.nextPage();
        vue.nextTick(() => {
          const newCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(SELECTOR)) : [];
          if (!rootContext.pagedNavigation.value) {
            const numberOfDays = date_comparators.getDaysInMonth(rootContext.placeholder.value.add({ months: rootContext.numberOfMonths.value - 1 }));
            newCollectionItems[newCollectionItems.length - numberOfDays + newIndex - allCollectionItems.length].focus();
            return;
          }
          newCollectionItems[newIndex - allCollectionItems.length].focus();
        });
      }
    }
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createBlock(vue.unref(Primitive_Primitive.Primitive), vue.mergeProps({
        ref_key: "primitiveElement",
        ref: primitiveElement
      }, props, {
        role: "button",
        "aria-label": labelText.value,
        "data-reka-calendar-cell-trigger": "",
        "aria-disabled": isDisabled.value || isUnavailable.value ? true : undefined,
        "data-selected": isSelectedDate.value ? true : undefined,
        "data-value": _ctx.day.toString(),
        "data-disabled": isDisabled.value ? "" : undefined,
        "data-unavailable": isUnavailable.value ? "" : undefined,
        "data-today": isDateToday.value ? "" : undefined,
        "data-outside-view": isOutsideView.value ? "" : undefined,
        "data-outside-visible-view": isOutsideVisibleView.value ? "" : undefined,
        "data-focused": isFocusedDate.value ? "" : undefined,
        tabindex: isFocusedDate.value ? 0 : isOutsideView.value || isDisabled.value ? undefined : -1,
        onClick: handleClick,
        onKeydown: [
          vue.withKeys(handleArrowKey, ["up", "down", "left", "right", "space", "enter"]),
          _cache[0] || (_cache[0] = vue.withKeys(vue.withModifiers(() => {
          }, ["prevent"]), ["enter"]))
        ]
      }), {
        default: vue.withCtx(() => [
          vue.renderSlot(_ctx.$slots, "default", {
            dayValue: dayValue.value,
            disabled: isDisabled.value,
            today: isDateToday.value,
            selected: isSelectedDate.value,
            outsideView: isOutsideView.value,
            outsideVisibleView: isOutsideVisibleView.value,
            unavailable: isUnavailable.value
          }, () => [
            vue.createTextVNode(vue.toDisplayString(dayValue.value), 1)
          ])
        ]),
        _: 3
      }, 16, ["aria-label", "aria-disabled", "data-selected", "data-value", "data-disabled", "data-unavailable", "data-today", "data-outside-view", "data-outside-visible-view", "data-focused", "tabindex"]);
    };
  }
});

exports._sfc_main = _sfc_main;
//# sourceMappingURL=CalendarCellTrigger.cjs.map
