import { defineComponent, openBlock, createBlock, unref, mergeProps, withCtx, renderSlot } from 'vue';
import { isEqualDay } from '@internationalized/date';
import '@floating-ui/vue';
import { i as injectDateRangePickerRootContext } from './DateRangePickerRoot.js';
import { _ as _sfc_main$1 } from '../RangeCalendar/RangeCalendarRoot.js';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "DateRangePickerCalendar",
  setup(__props) {
    const rootContext = injectDateRangePickerRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(_sfc_main$1), mergeProps({
        allowNonContiguousRanges: unref(rootContext).allowNonContiguousRanges.value,
        isDateDisabled: unref(rootContext).isDateDisabled,
        isDateUnavailable: unref(rootContext).isDateUnavailable,
        locale: unref(rootContext).locale.value,
        disabled: unref(rootContext).disabled.value,
        pagedNavigation: unref(rootContext).pagedNavigation.value,
        weekStartsOn: unref(rootContext).weekStartsOn.value,
        weekdayFormat: unref(rootContext).weekdayFormat.value,
        fixedWeeks: unref(rootContext).fixedWeeks.value,
        numberOfMonths: unref(rootContext).numberOfMonths.value,
        readonly: unref(rootContext).readonly.value,
        preventDeselect: unref(rootContext).preventDeselect.value,
        minValue: unref(rootContext).minValue.value,
        maxValue: unref(rootContext).maxValue.value,
        dir: unref(rootContext).dir.value
      }, {
        "initial-focus": "",
        "model-value": unref(rootContext).modelValue.value,
        placeholder: unref(rootContext).placeholder.value,
        "onUpdate:startValue": _cache[0] || (_cache[0] = (date) => {
          unref(rootContext).onStartValueChange(date);
        }),
        "onUpdate:modelValue": _cache[1] || (_cache[1] = (date) => {
          if (date.start && unref(rootContext).modelValue.value?.start && date.end && unref(rootContext).modelValue.value?.end && unref(isEqualDay)(date.start, unref(rootContext).modelValue.value?.start) && unref(isEqualDay)(date.end, unref(rootContext).modelValue.value?.end)) return;
          unref(rootContext).onDateChange(date);
        }),
        "onUpdate:placeholder": _cache[2] || (_cache[2] = (date) => {
          if (unref(isEqualDay)(date, unref(rootContext).placeholder.value)) return;
          unref(rootContext).onPlaceholderChange(date);
        })
      }), {
        default: withCtx(({ weekDays, grid, date, weekStartsOn, locale, fixedWeeks }) => [
          renderSlot(_ctx.$slots, "default", {
            date,
            grid,
            weekDays,
            weekStartsOn,
            locale,
            fixedWeeks
          })
        ]),
        _: 3
      }, 16, ["model-value", "placeholder"]);
    };
  }
});

export { _sfc_main as _ };
//# sourceMappingURL=DateRangePickerCalendar.js.map
