import { defineComponent, onMounted, openBlock, createBlock, unref, withCtx, createVNode, nextTick, withKeys, renderSlot } from 'vue';
import { _ as _sfc_main$1 } from '../Menu/MenuAnchor.js';
import { i as injectDropdownMenuRootContext } from './DropdownMenuRoot.js';
import { u as useForwardExpose } from '../shared/useForwardExpose.js';
import { u as useId } from '../shared/useId.js';
import { P as Primitive } from '../Primitive/Primitive.js';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "DropdownMenuTrigger",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(__props) {
    const props = __props;
    const rootContext = injectDropdownMenuRootContext();
    const { forwardRef, currentElement: triggerElement } = useForwardExpose();
    onMounted(() => {
      rootContext.triggerElement = triggerElement;
    });
    rootContext.triggerId ||= useId(undefined, "reka-dropdown-menu-trigger");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(_sfc_main$1), { "as-child": "" }, {
        default: withCtx(() => [
          createVNode(unref(Primitive), {
            id: unref(rootContext).triggerId,
            ref: unref(forwardRef),
            type: _ctx.as === "button" ? "button" : undefined,
            "as-child": props.asChild,
            as: _ctx.as,
            "aria-haspopup": "menu",
            "aria-expanded": unref(rootContext).open.value,
            "aria-controls": unref(rootContext).open.value ? unref(rootContext).contentId : undefined,
            "data-disabled": _ctx.disabled ? "" : undefined,
            disabled: _ctx.disabled,
            "data-state": unref(rootContext).open.value ? "open" : "closed",
            onClick: _cache[0] || (_cache[0] = async (event) => {
              if (!_ctx.disabled && event.button === 0 && event.ctrlKey === false) {
                unref(rootContext)?.onOpenToggle();
                await nextTick();
                if (unref(rootContext).open.value) event.preventDefault();
              }
            }),
            onKeydown: _cache[1] || (_cache[1] = withKeys(
              (event) => {
                if (_ctx.disabled) return;
                if (["Enter", " "].includes(event.key)) unref(rootContext).onOpenToggle();
                if (event.key === "ArrowDown") unref(rootContext).onOpenChange(true);
                if (["Enter", " ", "ArrowDown"].includes(event.key))
                  event.preventDefault();
              },
              ["enter", "space", "arrow-down"]
            ))
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }, 8, ["id", "type", "as-child", "as", "aria-expanded", "aria-controls", "data-disabled", "disabled", "data-state"])
        ]),
        _: 3
      });
    };
  }
});

export { _sfc_main as _ };
//# sourceMappingURL=DropdownMenuTrigger.js.map
