'use strict';

const vue = require('vue');
const Editable_EditableRoot = require('./EditableRoot.cjs');
const Primitive_Primitive = require('../Primitive/Primitive.cjs');

const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  __name: "EditableArea",
  props: {
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(__props) {
    const props = __props;
    const context = Editable_EditableRoot.injectEditableRootContext();
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createBlock(vue.unref(Primitive_Primitive.Primitive), vue.mergeProps(props, {
        "data-placeholder-shown": vue.unref(context).isEditing.value ? undefined : "",
        "data-focus": vue.unref(context).isEditing.value ? "" : undefined,
        "data-focused": vue.unref(context).isEditing.value ? "" : undefined,
        "data-empty": vue.unref(context).isEmpty.value ? "" : undefined,
        "data-readonly": vue.unref(context).readonly.value ? "" : undefined,
        "data-disabled": vue.unref(context).disabled.value ? "" : undefined,
        style: vue.unref(context).autoResize.value ? { display: "inline-grid" } : undefined
      }), {
        default: vue.withCtx(() => [
          vue.renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16, ["data-placeholder-shown", "data-focus", "data-focused", "data-empty", "data-readonly", "data-disabled", "style"]);
    };
  }
});

exports._sfc_main = _sfc_main;
//# sourceMappingURL=EditableArea.cjs.map
