import { defineComponent, openBlock, createBlock, unref, mergeProps, withCtx, renderSlot, createTextVNode } from 'vue';
import { P as Primitive } from '../Primitive/Primitive.js';
import { i as injectEditableRootContext } from './EditableRoot.js';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "EditableCancelTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(__props) {
    const props = __props;
    const context = injectEditableRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props, {
        "aria-label": "cancel",
        "aria-disabled": unref(context).disabled.value ? "" : undefined,
        "data-disabled": unref(context).disabled.value ? "" : undefined,
        disabled: unref(context).disabled.value,
        type: _ctx.as === "button" ? "button" : undefined,
        hidden: unref(context).isEditing.value ? undefined : "",
        onClick: unref(context).cancel
      }), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            _cache[0] || (_cache[0] = createTextVNode("Cancel"))
          ])
        ]),
        _: 3
      }, 16, ["aria-disabled", "data-disabled", "disabled", "type", "hidden", "onClick"]);
    };
  }
});

export { _sfc_main as _ };
//# sourceMappingURL=EditableCancelTrigger.js.map
