'use strict';

const vue = require('vue');
const Primitive_Primitive = require('../Primitive/Primitive.cjs');
const Editable_EditableRoot = require('./EditableRoot.cjs');

const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  __name: "EditableSubmitTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(__props) {
    const props = __props;
    const context = Editable_EditableRoot.injectEditableRootContext();
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createBlock(vue.unref(Primitive_Primitive.Primitive), vue.mergeProps(props, {
        "aria-label": "submit",
        "aria-disabled": vue.unref(context).disabled.value ? "" : undefined,
        "data-disabled": vue.unref(context).disabled.value ? "" : undefined,
        disabled: vue.unref(context).disabled.value,
        type: _ctx.as === "button" ? "button" : undefined,
        hidden: vue.unref(context).isEditing.value ? undefined : "",
        onClick: vue.unref(context).submit
      }), {
        default: vue.withCtx(() => [
          vue.renderSlot(_ctx.$slots, "default", {}, () => [
            _cache[0] || (_cache[0] = vue.createTextVNode("Submit"))
          ])
        ]),
        _: 3
      }, 16, ["aria-disabled", "data-disabled", "disabled", "type", "hidden", "onClick"]);
    };
  }
});

exports._sfc_main = _sfc_main;
//# sourceMappingURL=EditableSubmitTrigger.cjs.map
