'use strict';

function excludeTouch(eventHandler) {
  return (event) => event.pointerType === "touch" ? undefined : eventHandler();
}
function getTabbableNodes(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
    acceptNode: (node) => {
      return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
    }
  });
  while (walker.nextNode()) nodes.push(walker.currentNode);
  return nodes;
}

exports.excludeTouch = excludeTouch;
exports.getTabbableNodes = getTabbableNodes;
//# sourceMappingURL=utils.cjs.map
