import { isEqual } from 'ohash';

function queryCheckedElement(parentEl) {
  return parentEl?.querySelector("[data-state=checked]");
}
function valueComparator(value, currentValue, comparator) {
  if (value === undefined)
    return false;
  else if (Array.isArray(value))
    return value.some((val) => compare(val, currentValue, comparator));
  else
    return compare(value, currentValue, comparator);
}
function compare(value, currentValue, comparator) {
  if (value === undefined || currentValue === undefined)
    return false;
  if (typeof value === "string")
    return value === currentValue;
  if (typeof comparator === "function")
    return comparator(value, currentValue);
  if (typeof comparator === "string")
    return value?.[comparator] === currentValue?.[comparator];
  return isEqual(value, currentValue);
}

export { compare as c, queryCheckedElement as q, valueComparator as v };
//# sourceMappingURL=utils.js.map
