'use strict';

const vue = require('vue');
const Primitive_usePrimitiveElement = require('../Primitive/usePrimitiveElement.cjs');
const NumberField_NumberFieldRoot = require('./NumberFieldRoot.cjs');
const Primitive_Primitive = require('../Primitive/Primitive.cjs');
const shared_getActiveElement = require('../shared/getActiveElement.cjs');

const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  __name: "NumberFieldInput",
  props: {
    asChild: { type: Boolean },
    as: { default: "input" }
  },
  setup(__props) {
    const props = __props;
    const { primitiveElement, currentElement } = Primitive_usePrimitiveElement.usePrimitiveElement();
    const rootContext = NumberField_NumberFieldRoot.injectNumberFieldRootContext();
    function handleWheelEvent(event) {
      if (event.target !== shared_getActiveElement.getActiveElement())
        return;
      if (Math.abs(event.deltaY) <= Math.abs(event.deltaX))
        return;
      event.preventDefault();
      if (event.deltaY > 0)
        rootContext.handleIncrease();
      else if (event.deltaY < 0)
        rootContext.handleDecrease();
    }
    vue.onMounted(() => {
      rootContext.onInputElement(currentElement.value);
    });
    const inputValue = vue.ref(rootContext.textValue.value);
    vue.watch(() => rootContext.textValue.value, () => {
      inputValue.value = rootContext.textValue.value;
    }, { immediate: true, deep: true });
    function handleChange() {
      requestAnimationFrame(() => {
        inputValue.value = rootContext.textValue.value;
      });
    }
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createBlock(vue.unref(Primitive_Primitive.Primitive), vue.mergeProps(props, {
        id: vue.unref(rootContext).id.value,
        ref_key: "primitiveElement",
        ref: primitiveElement,
        value: inputValue.value,
        role: "spinbutton",
        type: "text",
        tabindex: "0",
        inputmode: vue.unref(rootContext).inputMode.value,
        disabled: vue.unref(rootContext).disabled.value ? "" : undefined,
        "data-disabled": vue.unref(rootContext).disabled.value ? "" : undefined,
        autocomplete: "off",
        autocorrect: "off",
        spellcheck: "false",
        "aria-roledescription": "Number field",
        "aria-valuenow": vue.unref(rootContext).modelValue.value,
        "aria-valuemin": vue.unref(rootContext).min.value,
        "aria-valuemax": vue.unref(rootContext).max.value,
        onKeydown: [
          _cache[0] || (_cache[0] = vue.withKeys(vue.withModifiers(($event) => vue.unref(rootContext).handleIncrease(), ["prevent"]), ["up"])),
          _cache[1] || (_cache[1] = vue.withKeys(vue.withModifiers(($event) => vue.unref(rootContext).handleDecrease(), ["prevent"]), ["down"])),
          _cache[2] || (_cache[2] = vue.withKeys(vue.withModifiers(($event) => vue.unref(rootContext).handleIncrease(10), ["prevent"]), ["page-up"])),
          _cache[3] || (_cache[3] = vue.withKeys(vue.withModifiers(($event) => vue.unref(rootContext).handleDecrease(10), ["prevent"]), ["page-down"])),
          _cache[4] || (_cache[4] = vue.withKeys(vue.withModifiers(($event) => vue.unref(rootContext).handleMinMaxValue("min"), ["prevent"]), ["home"])),
          _cache[5] || (_cache[5] = vue.withKeys(vue.withModifiers(($event) => vue.unref(rootContext).handleMinMaxValue("max"), ["prevent"]), ["end"])),
          _cache[8] || (_cache[8] = vue.withKeys(($event) => vue.unref(rootContext).applyInputValue($event.target?.value), ["enter"]))
        ],
        onWheel: handleWheelEvent,
        onBeforeinput: _cache[6] || (_cache[6] = (event) => {
          const target = event.target;
          let nextValue = target.value.slice(0, target.selectionStart ?? undefined) + (event.data ?? "") + target.value.slice(target.selectionEnd ?? undefined);
          if (!vue.unref(rootContext).validate(nextValue))
            event.preventDefault();
        }),
        onInput: _cache[7] || (_cache[7] = (event) => {
          const target = event.target;
          inputValue.value = target.value;
        }),
        onChange: handleChange,
        onBlur: _cache[9] || (_cache[9] = ($event) => vue.unref(rootContext).applyInputValue($event.target?.value))
      }), {
        default: vue.withCtx(() => [
          vue.renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16, ["id", "value", "inputmode", "disabled", "data-disabled", "aria-valuenow", "aria-valuemin", "aria-valuemax"]);
    };
  }
});

exports._sfc_main = _sfc_main;
//# sourceMappingURL=NumberFieldInput.cjs.map
