import { defineComponent, computed, openBlock, createBlock, unref, mergeProps, withKeys, withCtx, renderSlot, createTextVNode, toDisplayString, nextTick } from 'vue';
import { isToday, getLocalTimeZone, isSameMonth, isSameDay } from '@internationalized/date';
import { t as toDate, f as isBetweenInclusive, g as getDaysInMonth } from '../date/comparators.js';
import { u as usePrimitiveElement } from '../Primitive/usePrimitiveElement.js';
import { P as Primitive } from '../Primitive/Primitive.js';
import { u as useKbd } from '../shared/useKbd.js';
import { i as injectRangeCalendarRootContext } from './RangeCalendarRoot.js';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "RangeCalendarCellTrigger",
  props: {
    day: {},
    month: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(__props) {
    const props = __props;
    const rootContext = injectRangeCalendarRootContext();
    const kbd = useKbd();
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const labelText = computed(() => rootContext.formatter.custom(toDate(props.day), {
      weekday: "long",
      month: "long",
      day: "numeric",
      year: "numeric"
    }));
    const isDisabled = computed(() => rootContext.isDateDisabled(props.day));
    const isUnavailable = computed(() => rootContext.isDateUnavailable?.(props.day) ?? false);
    const isSelectedDate = computed(() => rootContext.isSelected(props.day));
    const isSelectionStart = computed(() => rootContext.isSelectionStart(props.day));
    const isSelectionEnd = computed(() => rootContext.isSelectionEnd(props.day));
    const isHighlightStart = computed(() => rootContext.isHighlightedStart(props.day));
    const isHighlightEnd = computed(() => rootContext.isHighlightedEnd(props.day));
    const isHighlighted = computed(() => rootContext.highlightedRange.value ? isBetweenInclusive(props.day, rootContext.highlightedRange.value.start, rootContext.highlightedRange.value.end) : false);
    const SELECTOR = "[data-reka-calendar-cell-trigger]:not([data-disabled]):not([data-outside-view]):not([data-outside-visible-view])";
    const isDateToday = computed(() => {
      return isToday(props.day, getLocalTimeZone());
    });
    const isOutsideView = computed(() => {
      return !isSameMonth(props.day, props.month);
    });
    const isOutsideVisibleView = computed(
      () => rootContext.isOutsideVisibleView(props.day)
    );
    const dayValue = computed(() => props.day.day.toLocaleString(rootContext.locale.value));
    const isFocusedDate = computed(() => {
      return !rootContext.disabled.value && isSameDay(props.day, rootContext.placeholder.value);
    });
    function changeDate(e, date) {
      if (rootContext.readonly.value)
        return;
      if (rootContext.isDateDisabled(date) || rootContext.isDateUnavailable?.(date))
        return;
      rootContext.lastPressedDateValue.value = date.copy();
      if (rootContext.startValue.value && rootContext.highlightedRange.value === null) {
        if (isSameDay(date, rootContext.startValue.value) && !rootContext.preventDeselect.value && !rootContext.endValue.value) {
          rootContext.startValue.value = undefined;
          rootContext.onPlaceholderChange(date);
          return;
        } else if (!rootContext.endValue.value) {
          e.preventDefault();
          if (rootContext.lastPressedDateValue.value && isSameDay(rootContext.lastPressedDateValue.value, date))
            rootContext.startValue.value = date.copy();
          return;
        }
      }
      if (rootContext.startValue.value && rootContext.endValue.value && isSameDay(rootContext.endValue.value, date) && !rootContext.preventDeselect.value) {
        rootContext.startValue.value = undefined;
        rootContext.endValue.value = undefined;
        rootContext.onPlaceholderChange(date);
        return;
      }
      if (!rootContext.startValue.value) {
        rootContext.startValue.value = date.copy();
      } else if (!rootContext.endValue.value) {
        rootContext.endValue.value = date.copy();
      } else if (rootContext.endValue.value && rootContext.startValue.value) {
        rootContext.endValue.value = undefined;
        rootContext.startValue.value = date.copy();
      }
    }
    function handleClick(e) {
      changeDate(e, props.day);
    }
    function handleFocus() {
      if (rootContext.isDateDisabled(props.day) || rootContext.isDateUnavailable?.(props.day))
        return;
      rootContext.focusedValue.value = props.day.copy();
    }
    function handleArrowKey(e) {
      e.preventDefault();
      e.stopPropagation();
      const parentElement = rootContext.parentElement.value;
      const allCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(SELECTOR)) : [];
      const index = allCollectionItems.indexOf(currentElement.value);
      let newIndex = index;
      const indexIncrementation = 7;
      const sign = rootContext.dir.value === "rtl" ? -1 : 1;
      switch (e.code) {
        case kbd.ARROW_RIGHT:
          newIndex += sign;
          break;
        case kbd.ARROW_LEFT:
          newIndex -= sign;
          break;
        case kbd.ARROW_UP:
          newIndex -= indexIncrementation;
          break;
        case kbd.ARROW_DOWN:
          newIndex += indexIncrementation;
          break;
        case kbd.ENTER:
        case kbd.SPACE_CODE:
          changeDate(e, props.day);
          return;
        default:
          return;
      }
      if (newIndex >= 0 && newIndex < allCollectionItems.length) {
        allCollectionItems[newIndex].focus();
        return;
      }
      if (newIndex < 0) {
        if (rootContext.isPrevButtonDisabled())
          return;
        rootContext.prevPage();
        nextTick(() => {
          const newCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(SELECTOR)) : [];
          if (!rootContext.pagedNavigation.value) {
            const numberOfDays = getDaysInMonth(rootContext.placeholder.value);
            newCollectionItems[numberOfDays - Math.abs(newIndex)].focus();
            return;
          }
          newCollectionItems[newCollectionItems.length - Math.abs(newIndex)].focus();
        });
        return;
      }
      if (newIndex >= allCollectionItems.length) {
        if (rootContext.isNextButtonDisabled())
          return;
        rootContext.nextPage();
        nextTick(() => {
          const newCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(SELECTOR)) : [];
          if (!rootContext.pagedNavigation.value) {
            const numberOfDays = getDaysInMonth(rootContext.placeholder.value.add({ months: rootContext.numberOfMonths.value - 1 }));
            newCollectionItems[newCollectionItems.length - numberOfDays + newIndex - allCollectionItems.length].focus();
            return;
          }
          newCollectionItems[newIndex - allCollectionItems.length].focus();
        });
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        ref_key: "primitiveElement",
        ref: primitiveElement
      }, props, {
        role: "button",
        "aria-label": labelText.value,
        "data-reka-calendar-cell-trigger": "",
        "aria-selected": isSelectedDate.value && !isUnavailable.value ? true : undefined,
        "aria-disabled": isDisabled.value || isUnavailable.value ? true : undefined,
        "data-highlighted": isHighlighted.value && !isUnavailable.value ? "" : undefined,
        "data-selection-start": isSelectionStart.value ? true : undefined,
        "data-selection-end": isSelectionEnd.value ? true : undefined,
        "data-highlighted-start": isHighlightStart.value ? true : undefined,
        "data-highlighted-end": isHighlightEnd.value ? true : undefined,
        "data-selected": isSelectedDate.value && !isUnavailable.value ? true : undefined,
        "data-outside-visible-view": isOutsideVisibleView.value ? "" : undefined,
        "data-value": _ctx.day.toString(),
        "data-disabled": isDisabled.value ? "" : undefined,
        "data-unavailable": isUnavailable.value ? "" : undefined,
        "data-today": isDateToday.value ? "" : undefined,
        "data-outside-view": isOutsideView.value ? "" : undefined,
        "data-focused": isFocusedDate.value ? "" : undefined,
        tabindex: isFocusedDate.value ? 0 : isOutsideView.value || isDisabled.value ? undefined : -1,
        onClick: handleClick,
        onFocusin: handleFocus,
        onMouseenter: handleFocus,
        onKeydown: withKeys(handleArrowKey, ["up", "down", "left", "right", "enter", "space"])
      }), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {
            dayValue: dayValue.value,
            disabled: isDisabled.value,
            today: isDateToday.value,
            selected: isSelectedDate.value,
            outsideView: isOutsideView.value,
            outsideVisibleView: isOutsideVisibleView.value,
            unavailable: isUnavailable.value,
            highlighted: isHighlighted.value && !isUnavailable.value,
            highlightedStart: isHighlightStart.value,
            highlightedEnd: isHighlightEnd.value,
            selectionStart: isSelectionStart.value,
            selectionEnd: isSelectionEnd.value
          }, () => [
            createTextVNode(toDisplayString(dayValue.value), 1)
          ])
        ]),
        _: 3
      }, 16, ["aria-label", "aria-selected", "aria-disabled", "data-highlighted", "data-selection-start", "data-selection-end", "data-highlighted-start", "data-highlighted-end", "data-selected", "data-outside-visible-view", "data-value", "data-disabled", "data-unavailable", "data-today", "data-outside-view", "data-focused", "tabindex"]);
    };
  }
});

export { _sfc_main as _ };
//# sourceMappingURL=RangeCalendarCellTrigger.js.map
