import { defineComponent, ref, computed, watch, openBlock, createBlock, unref, mergeProps, withCtx, renderSlot, createCommentVNode } from 'vue';
import { useResizeObserver } from '@vueuse/core';
import { P as Primitive } from '../Primitive/Primitive.js';
import { i as injectScrollAreaRootContext } from './ScrollAreaRoot.js';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ScrollAreaCornerImpl",
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const width = ref(0);
    const height = ref(0);
    const hasSize = computed(() => !!width.value && !!height.value);
    function setCornerHeight() {
      const offsetHeight = rootContext.scrollbarX.value?.offsetHeight || 0;
      rootContext.onCornerHeightChange(offsetHeight);
      height.value = offsetHeight;
    }
    function setCornerWidth() {
      const offsetWidth = rootContext.scrollbarY.value?.offsetWidth || 0;
      rootContext.onCornerWidthChange(offsetWidth);
      width.value = offsetWidth;
    }
    useResizeObserver(rootContext.scrollbarX.value, setCornerHeight);
    useResizeObserver(rootContext.scrollbarY.value, setCornerWidth);
    watch(() => rootContext.scrollbarX.value, setCornerHeight);
    watch(() => rootContext.scrollbarY.value, setCornerWidth);
    return (_ctx, _cache) => {
      return hasSize.value ? (openBlock(), createBlock(unref(Primitive), mergeProps({
        key: 0,
        style: {
          width: `${width.value}px`,
          height: `${height.value}px`,
          position: "absolute",
          right: unref(rootContext).dir.value === "ltr" ? 0 : undefined,
          left: unref(rootContext).dir.value === "rtl" ? 0 : undefined,
          bottom: 0
        }
      }, _ctx.$parent?.$props), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16, ["style"])) : createCommentVNode("", true);
    };
  }
});

export { _sfc_main as _ };
//# sourceMappingURL=ScrollAreaCornerImpl.js.map
