import { defineComponent, toRefs, computed, ref, onMounted, openBlock, createBlock, unref, withCtx, createVNode, withModifiers, renderSlot, nextTick } from 'vue';
import { v as valueComparator, S as SELECTION_KEYS } from './utils.js';
import { u as useCollection } from '../Collection/Collection.js';
import { u as useForwardExpose } from '../shared/useForwardExpose.js';
import { u as useId } from '../shared/useId.js';
import { P as Primitive } from '../Primitive/Primitive.js';
import { c as createContext } from '../shared/createContext.js';
import { h as handleAndDispatchCustomEvent } from '../shared/handleAndDispatchCustomEvent.js';
import { g as getActiveElement } from '../shared/getActiveElement.js';
import { i as injectSelectRootContext } from './SelectRoot.js';
import { i as injectSelectContentContext } from './SelectContentImpl.js';

const [injectSelectItemContext, provideSelectItemContext] = createContext("SelectItem");
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SelectItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emits = __emit;
    const { disabled } = toRefs(props);
    const rootContext = injectSelectRootContext();
    const contentContext = injectSelectContentContext();
    const { forwardRef, currentElement } = useForwardExpose();
    const { CollectionItem } = useCollection();
    const isSelected = computed(() => valueComparator(rootContext.modelValue?.value, props.value, rootContext.by));
    const isFocused = ref(false);
    const textValue = ref(props.textValue ?? "");
    const textId = useId(undefined, "reka-select-item-text");
    const SELECT_SELECT = "select.select";
    async function handleSelectCustomEvent(ev) {
      if (ev.defaultPrevented)
        return;
      const eventDetail = { originalEvent: ev, value: props.value };
      handleAndDispatchCustomEvent(SELECT_SELECT, handleSelect, eventDetail);
    }
    async function handleSelect(ev) {
      await nextTick();
      emits("select", ev);
      if (ev.defaultPrevented)
        return;
      if (!disabled.value) {
        rootContext.onValueChange(props.value);
        if (!rootContext.multiple.value)
          rootContext.onOpenChange(false);
      }
    }
    async function handlePointerMove(event) {
      await nextTick();
      if (event.defaultPrevented)
        return;
      if (disabled.value) {
        contentContext.onItemLeave?.();
      } else {
        event.currentTarget.focus({ preventScroll: true });
      }
    }
    async function handlePointerLeave(event) {
      await nextTick();
      if (event.defaultPrevented)
        return;
      if (event.currentTarget === getActiveElement())
        contentContext.onItemLeave?.();
    }
    async function handleKeyDown(event) {
      await nextTick();
      if (event.defaultPrevented)
        return;
      const isTypingAhead = contentContext.searchRef?.value !== "";
      if (isTypingAhead && event.key === " ")
        return;
      if (SELECTION_KEYS.includes(event.key))
        handleSelectCustomEvent(event);
      if (event.key === " ")
        event.preventDefault();
    }
    if (props.value === "") {
      throw new Error(
        "A <SelectItem /> must have a value prop that is not an empty string. This is because the Select value can be set to an empty string to clear the selection and show the placeholder."
      );
    }
    onMounted(() => {
      if (!currentElement.value)
        return;
      contentContext.itemRefCallback(
        currentElement.value,
        props.value,
        props.disabled
      );
    });
    provideSelectItemContext({
      value: props.value,
      disabled,
      textId,
      isSelected,
      onItemTextChange: (node) => {
        textValue.value = ((textValue.value || node?.textContent) ?? "").trim();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionItem), {
        value: { textValue: textValue.value }
      }, {
        default: withCtx(() => [
          createVNode(unref(Primitive), {
            ref: unref(forwardRef),
            role: "option",
            "aria-labelledby": unref(textId),
            "data-highlighted": isFocused.value ? "" : undefined,
            "aria-selected": isSelected.value,
            "data-state": isSelected.value ? "checked" : "unchecked",
            "aria-disabled": unref(disabled) || undefined,
            "data-disabled": unref(disabled) ? "" : undefined,
            tabindex: unref(disabled) ? undefined : -1,
            as: _ctx.as,
            "as-child": _ctx.asChild,
            onFocus: _cache[0] || (_cache[0] = ($event) => isFocused.value = true),
            onBlur: _cache[1] || (_cache[1] = ($event) => isFocused.value = false),
            onPointerup: handleSelectCustomEvent,
            onPointerdown: _cache[2] || (_cache[2] = (event) => {
              event.currentTarget.focus({ preventScroll: true });
            }),
            onTouchend: _cache[3] || (_cache[3] = withModifiers(() => {
            }, ["prevent", "stop"])),
            onPointermove: handlePointerMove,
            onPointerleave: handlePointerLeave,
            onKeydown: handleKeyDown
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }, 8, ["aria-labelledby", "data-highlighted", "aria-selected", "data-state", "aria-disabled", "data-disabled", "tabindex", "as", "as-child"])
        ]),
        _: 3
      }, 8, ["value"]);
    };
  }
});

export { _sfc_main as _, injectSelectItemContext as i };
//# sourceMappingURL=SelectItem.js.map
