import { defineComponent, toRefs, ref, computed, openBlock, createBlock, unref, withCtx, renderSlot } from 'vue';
import { _ as _sfc_main$1 } from './SliderImpl.js';
import { p as provideSliderOrientationContext, B as BACK_KEYS, l as linearScale } from './utils.js';
import { u as useForwardExpose } from '../shared/useForwardExpose.js';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SliderVertical",
  props: {
    min: {},
    max: {},
    inverted: { type: Boolean }
  },
  emits: ["slideEnd", "slideStart", "slideMove", "homeKeyDown", "endKeyDown", "stepKeyDown"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emits = __emit;
    const { max, min, inverted } = toRefs(props);
    const { forwardRef, currentElement: sliderElement } = useForwardExpose();
    const rectRef = ref();
    const isSlidingFromBottom = computed(() => !inverted.value);
    function getValueFromPointer(pointerPosition) {
      const rect = rectRef.value || sliderElement.value.getBoundingClientRect();
      const input = [0, rect.height];
      const output = isSlidingFromBottom.value ? [max.value, min.value] : [min.value, max.value];
      const value = linearScale(input, output);
      rectRef.value = rect;
      return value(pointerPosition - rect.top);
    }
    provideSliderOrientationContext({
      startEdge: isSlidingFromBottom.value ? "bottom" : "top",
      endEdge: isSlidingFromBottom.value ? "top" : "bottom",
      size: "height",
      direction: isSlidingFromBottom.value ? 1 : -1
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1, {
        ref: unref(forwardRef),
        "data-orientation": "vertical",
        style: {
          ["--reka-slider-thumb-transform"]: "translateY(50%)"
        },
        onSlideStart: _cache[0] || (_cache[0] = (event) => {
          const value = getValueFromPointer(event.clientY);
          emits("slideStart", value);
        }),
        onSlideMove: _cache[1] || (_cache[1] = (event) => {
          const value = getValueFromPointer(event.clientY);
          emits("slideMove", value);
        }),
        onSlideEnd: _cache[2] || (_cache[2] = () => {
          rectRef.value = undefined;
          emits("slideEnd");
        }),
        onStepKeyDown: _cache[3] || (_cache[3] = (event) => {
          const slideDirection = isSlidingFromBottom.value ? "from-bottom" : "from-top";
          const isBackKey = unref(BACK_KEYS)[slideDirection].includes(event.key);
          emits("stepKeyDown", event, isBackKey ? -1 : 1);
        }),
        onEndKeyDown: _cache[4] || (_cache[4] = ($event) => emits("endKeyDown", $event)),
        onHomeKeyDown: _cache[5] || (_cache[5] = ($event) => emits("homeKeyDown", $event))
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 512);
    };
  }
});

export { _sfc_main as _ };
//# sourceMappingURL=SliderVertical.js.map
