import axios from "axios";
const axiosInstance = axios.create({
    baseURL: "http://127.0.0.1:8000/api/",
    // withCredentials: true
});

axiosInstance.interceptors.request.use(config => {
    const token = localStorage.getItem('token');
    if (token) {
        config.headers.Authorization = `Bearer ${token}`;
    }
    return config;
}, error => {
    return Promise.reject(error);
});

// axiosInstance.defaults.withCredentials = true;
export default axiosInstance;