import { createI18n } from 'vue-i18n';

const messages = {
    fr: {
        login: {
            title: "Connexion",
            subtitle: "Accédez à votre compte en toute sécurité",
            email: "Adresse e-mail",
            password: "Mot de passe",
            noAccount: "Vous n'avez pas de compte ?",
            register: "Inscrivez-vous",
            loginButton: "Se connecter",
            loading: "Chargement...",
            errorMessage: "Une erreur s'est produite.",
        },
        register: {
            title: "Créez votre compte",
            subtitle: "Inscrivez-vous pour accéder à votre espace personnel",
            firstName: "Prénom",
            firstNamePlaceholder: "John",
            lastName: "Nom",
            lastNamePlaceholder: "Doe",
            email: "Adresse e-mail",
            emailPlaceholder: "admin@gmail.com",
            password: "Mot de passe",
            passwordPlaceholder: "******",
            alreadyHaveAccount: "Vous avez déjà un compte ?",
            login: "Connectez-vous",
            registerButton: "S'inscrire",
            loading: "Chargement...",
            errorMessage: "Une erreur s'est produite.",
        },
        step1: {
            title: "Étape 1 : Informations de l'entreprise",
            description: "Veuillez remplir les informations nécessaires pour continuer.",
            placeholder: "Entrer le numéro d'entreprise ici",
            selectLanguage: "Sélectionnez la langue s'il vous plaît :",
            french: "Français",
            dutch: "Nederlands",
            searchButton: "Rechercher",
            loading: "Chargement...",
            errorNoEnterpriseNumber: "Veuillez saisir un numéro d'entreprise avant de continuer.",
            errorNoLanguage: "Veuillez sélectionner une langue avant de continuer.",
            errorSearch: "Une erreur s'est produite lors de la recherche de l'entreprise.",
            errorIndividualEnterprise: "Désolé, nous ne pouvons pas traiter les entreprises individuelles pour le moment.",
            errorInactiveEnterprise: "Désolé, nous ne pouvons pas traiter les entreprises inactives pour le moment.",
            errorNoEnterpriseFound: "Aucune entreprise trouvée avec ce numéro.",
        },
        step1Validate: {
            title: "Informations sur l\’Entreprise",
            description: "Voici les détails de l\’entreprise correspondant au numéro saisi.",
            nextButton: "Suivant",
            loading: "Chargement...",
        },
        services: {
            title: "Que souhaitez-vous modifier dans la société?",
            description: "Spécifiez les changements que vous souhaitez apporter à votre entreprise.",
            address: "Adresse",
            dirigeants: "Dirigeants",
            cessionParts: "Cession de parts",
            nextButton: "Suivant",
            loading: "Chargement...",
        },
        step2: {
            title: "Vérification requise",
            description: "Veuillez entrer un numéro de téléphone pour envoyer le lien de vérification.",
            phonePlaceholder: "+33 6 xx xx xx xx",
            verificationSent: "Lien de vérification envoyé ! Le dirigeant recevra un lien pour confirmer son identité.",
            sendLink: "Envoyer le lien",
            cancel: "Annuler",
            inEnterpriseDescription: "Avant de continuer, précisez si vous faites partie de l'entreprise. Cela nous aidera à adapter le processus et récupérer les données nécessaires.",
            yes: "Oui",
            no: "Non",
            loading: "Chargement...",
            continue: "Continuer",
            errorFillFields: "Veuillez remplir tous les champs obligatoires avant de continuer.",
            errorVerification: "Veuillez envoyer la vérification avant de continuer.",
        },
        step3: {
            title: "Quelle est la date de modification de statut?",
            description: "Veuillez indiquer la date à laquelle le changement a été effectué, ainsi que la date de l’assemblée générale ayant validé cette modification.",
            changeDate: "Date du changement",
            generalMeetingDate: "Date de l’assemblée générale",
            loading: "Chargement...",
            continue: "Continuer",
            errorMissingDates: "Veuillez sélectionner une date pour le changement de statut et/ou la date de l’assemblée générale.",
        },
        address: {
            title: "Mon Adresse",
            subtitle: "Consultez et modifiez votre adresse",
            current: "Adresse actuelle",
            primary: "Principale",
            enterNew: "Entrez votre nouvelle adresse",
            enterInstructions: "Saisissez l'adresse complète dans le format que vous souhaitez",
            placeholder: "Rue et numéro\nComplément d'adresse\nCode postal et ville\nPays\nTéléphone",
            save: "Enregistrer la nouvelle adresse",
            loading: "Chargement"
        },
        dirigeants: {
            title: "Dirigeants",
            subtitle: "Ajoutez, modifiez ou vérifiez les informations des dirigeants.",
            addButton: "Ajouter un dirigeant",
            addFormTitle: "Ajouter un dirigeant",
            lastname: "Nom",
            firstname: "Prénom",
            lastnamePlaceholder: "Entrez le nom",
            firstnamePlaceholder: "Entrez le prénom",
            add: "Ajouter",
            cancel: "Annuler",
            edit: "Modifier",
            verificationTitle: "Vérification du dirigeant",
            verificationText: "Souhaitez-vous envoyer un lien de vérification à ",
            sendLink: "Envoyer le lien",
            linkSent: "Lien envoyé avec succès.",
            listTitle: "Liste des dirigeants",
            status: "Statut",
            actions: "Actions",
            continue: "Continuer",
            loading: "Chargement..."
        },
        cessionParts: {
            amount: "Montant",
            totalActions: "Total d'actions",
            errorSharesMessage: "La somme des parts des actionnaires doit être égale au nombre d’actions de l’entreprise.",
            title: "Répartition des parts sociales",
            subtitle: "Détail des actionnaires de la société et du nombre de parts détenues par chacun",
            addButton: "Ajouter une personne",
            addFormTitle: "Ajouter un nouveau actionnaire",
            fullName: "Nom complet",
            fullNamePlaceholder: "Entrez le nom complet",
            shares: "Pourcentage de parts",
            sharesPlaceholder: "Entrez le pourcentage de parts",
            add: "Ajouter",
            cancel: "Annuler",
            editFormTitle: "Modifier un actionnaire",
            save: "Enregistrer",
            listTitle: "Liste des actionnaires",
            actions: "Actions",
            edit: "Modifier",
            loading: "Chargement...",
            continue: "Continuer",
            titl_verif: "Vérification requise",
            description: "Pour finaliser l'ajout ou la modification de {givenName} {surname}, veuillez entrer un numéro de téléphone pour envoyer le lien de vérification.",
            phonePlaceholder: "+33 6 xx xx xx xx",
            sentMessage: "Lien de vérification envoyé ! Le dirigeant recevra un lien pour confirmer son identité.",
            sendButton: "Envoyer le lien",
            cancelButton: "Annuler",
        },
        finishStep: {
            congratulations: "Félicitations !",
            successMessage1: "Vous avez terminé toutes les étapes avec succès.",
            successMessage2: "Veuillez patienter pendant que nous examinons votre soumission pour approbation.",
            returnHome: "Retourner à la page d'accueil",
        },
        dashboard: {
            dashboard: "Dashboard",
            requests: "Demandes",
            support: "Assistance",
            claims: "Réclamations",
            demandes: "Mes Demandes",
            reclamations: "Réclamations",
            mes_demandes: "Mes demandes",
            id: "ID",
            numero_entreprise: "Numéro d\'entreprise",
            langue: "Langue",
            services: "Services",
            adresse: "Adresse",
            dirigeants: "Dirigeants",
            cession_parts: "Cession Parts",
            date_creation: "Date de création",
            actions: "Actions",
            voir_dossier: "Voir le dossier",
            telecharger_dossier: "Télécharger le dossier"
        },
        form: {
            title: 'Formulaire de Réclamation',
            subtitle: 'Veuillez remplir ce formulaire pour soumettre votre réclamation',
            type: {
                label: 'Type de réclamation',
                placeholder: 'Sélectionnez un type de réclamation',
            },
            demande: {
                label: 'Demande',
                placeholder: 'Sélectionnez une demande',
            },
            description: {
                label: 'Description du problème',
                placeholder: 'Décrivez votre problème en détail...',
                remaining: 'caractères restants',
            },
            contact: {
                title: 'Vos coordonnées',
                name: 'Nom complet',
                email: 'Email',
            },
            actions: {
                cancel: 'Annuler',
                submit: 'Envoyer la réclamation',
                submitting: 'Envoi en cours...',
            },
            success: 'Votre réclamation a été envoyée avec succès ! Un numéro de référence vous sera envoyé par email.',
        },
        table: {
            title: 'Mes réclamations',
            headers: {
              id: 'Id',
              type: 'Type',
              clientName: 'Nom du client', 
              demandeId: 'ID de demande',  
              email: 'Email',
              status: 'Statut',           
              date: 'Date',
            },
            status: {
              cancelled: 'annulé',
              resolved: 'résolu',
              pending: 'en attente',
            },
        },
        generateTextIa: {
            title: "Générateur de texte avec IA",
            subtitle: "Générez du texte publier à l'aide de l'IA",
            loading: "Chargement...",
            terminer: "Terminer",
            label: "Modifier le text si nécessaire",

        }

    },
    nl: {
        login: {
            title: "Inloggen",
            subtitle: "Log veilig in op uw account",
            email: "E-mailadres",
            password: "Wachtwoord",
            noAccount: "Heeft u geen account?",
            register: "Registreer",
            loginButton: "Inloggen",
            loading: "Laden...",
            errorMessage: "Er is een fout opgetreden.",
        },
        register: {
            title: "Maak uw account aan",
            subtitle: "Registreer om toegang te krijgen tot uw persoonlijke ruimte",
            firstName: "Voornaam",
            firstNamePlaceholder: "Jan",
            lastName: "Achternaam",
            lastNamePlaceholder: "Doe",
            email: "E-mailadres",
            emailPlaceholder: "admin@gmail.com",
            password: "Wachtwoord",
            passwordPlaceholder: "******",
            alreadyHaveAccount: "Heeft u al een account?",
            login: "Log in",
            registerButton: "Registreren",
            loading: "Laden...",
            errorMessage: "Er is een fout opgetreden.",
        },
        step1: {
            title: "Stap 1: Bedrijfsinformatie",
            description: "Vul de benodigde informatie in om verder te gaan.",
            placeholder: "Voer hier het ondernemingsnummer in",
            selectLanguage: "Selecteer alstublieft de taal:",
            french: "Frans",
            dutch: "Nederlands",
            searchButton: "Zoeken",
            loading: "Laden...",
            errorNoEnterpriseNumber: "Voer een ondernemingsnummer in voordat u doorgaat.",
            errorNoLanguage: "Selecteer een taal voordat u doorgaat.",
            errorSearch: "Er is een fout opgetreden bij het zoeken naar het bedrijf.",
            errorIndividualEnterprise: "Sorry, we kunnen momenteel geen individuele bedrijven verwerken.",
            errorInactiveEnterprise: "Sorry, we kunnen momenteel geen inactieve bedrijven verwerken.",
            errorNoEnterpriseFound: "Geen bedrijf gevonden met dit nummer.",
        },
        step1Validate: {
            title: "Bedrijfsinformatie",
            description: "Hier zijn de details van het bedrijf dat overeenkomt met het ingevoerde nummer.",
            nextButton: "Volgende",
            loading: "Laden...",
        },
        services: {
            title: "Wat wilt u wijzigen in het bedrijf?",
            description: "Geef de wijzigingen op die u in uw bedrijf wilt aanbrengen.",
            address: "Adres",
            dirigeants: "Leidinggevenden",
            cessionParts: "Overdracht van aandelen",
            nextButton: "Volgende",
            loading: "Laden...",
        },
        step2: {
            title: "Verificatie vereist",
            description: "Voer een telefoonnummer in om de verificatielink te verzenden.",
            phonePlaceholder: "+31 6 xx xx xx xx",
            verificationSent: "Verificatielink verzonden! De bestuurder ontvangt een link om zijn identiteit te bevestigen.",
            sendLink: "Stuur de link",
            cancel: "Annuleren",
            inEnterpriseDescription: "Voordat u doorgaat, geeft u aan of u deel uitmaakt van het bedrijf. Dit helpt ons het proces aan te passen en de benodigde gegevens te verzamelen.",
            yes: "Ja",
            no: "Nee",
            loading: "Laden...",
            continue: "Doorgaan",
            errorFillFields: "Vul alle verplichte velden in voordat u doorgaat.",
            errorVerification: "Stuur de verificatie voordat u doorgaat.",
        },
        step3: {
            title: "Wat is de datum van de statutenwijziging?",
            description: "Geef de datum op waarop de wijziging is doorgevoerd, evenals de datum van de algemene vergadering die deze wijziging heeft goedgekeurd.",
            changeDate: "Datum van wijziging",
            generalMeetingDate: "Datum van de algemene vergadering",
            loading: "Laden...",
            continue: "Doorgaan",
            errorMissingDates: "Selecteer een datum voor de statutenwijziging en/of de datum van de algemene vergadering.",
        },
        address: {
            title: "Mijn adres",
            subtitle: "Bekijk en wijzig uw adres",
            current: "Huidig adres",
            primary: "Primair",
            enterNew: "Voer uw nieuw adres in",
            enterInstructions: "Voer het volledige adres in, in het gewenste formaat",
            placeholder: "Straat en nummer\nAdresaanvulling\nPostcode en stad\nLand\nTelefoon",
            save: "Nieuw adres opslaan",
            loading: "Bezig met laden",
        },
        dirigeants: {
            title: "Bestuurders",
            subtitle: "Voeg bestuurders toe, wijzig ze of verifieer hun informatie.",
            addButton: "Bestuurder toevoegen",
            addFormTitle: "Voeg een bestuurder toe",
            lastname: "Achternaam",
            firstname: "Voornaam",
            lastnamePlaceholder: "Vul de achternaam in",
            firstnamePlaceholder: "Vul de voornaam in",
            add: "Toevoegen",
            cancel: "Annuleren",
            edit: "Bewerken",
            verificationTitle: "Verificatie van bestuurder",
            verificationText: "Wilt u een verificatielink sturen naar {{ name }}?",
            sendLink: "Link verzenden",
            linkSent: "Link succesvol verzonden.",
            listTitle: "Lijst van bestuurders",
            status: "Status",
            actions: "Acties",
            continue: "Doorgaan",
            loading: "Bezig met laden..."
        },
        cessionParts: {
            errorSharesMessage: "De som van de aandelen van de aandeelhouders moet gelijk zijn aan het aantal aandelen van het bedrijf.",
            amount : "Bedrag",
            totalActions: "Totaal aantal aandelen",
            title: "Verdeling van aandelen",
            subtitle: "Details van de aandeelhouders van het bedrijf en het aantal aandelen dat elk bezit",
            addButton: "Voeg een persoon toe",
            addFormTitle: "Voeg een nieuwe aandeelhouder toe",
            fullName: "Volledige naam",
            fullNamePlaceholder: "Voer de volledige naam in",
            shares: "Percentage aandelen",
            sharesPlaceholder: "Voer het percentage aandelen in",
            add: "Toevoegen",
            cancel: "Annuleren",
            editFormTitle: "Bewerk een aandeelhouder",
            save: "Opslaan",
            listTitle: "Lijst van aandeelhouders",
            actions: "Acties",
            edit: "Bewerken",
            loading: "Laden...",
            continue: "Doorgaan",
            title_verif: "Verificatie vereist",
            description: "Om het toevoegen of bewerken van {givenName} {surname} te voltooien, voert u een telefoonnummer in om de verificatielink te verzenden.",
            phonePlaceholder: "+31 6 xx xx xx xx",
            sentMessage: "Verificatielink verzonden! De bestuurder ontvangt een link om zijn identiteit te bevestigen.",
            sendButton: "Verzend de link",
            cancelButton: "Annuleren",
        },
        finishStep: {
            congratulations: "Gefeliciteerd!",
            successMessage1: "U heeft alle stappen met succes voltooid.",
            successMessage2: "Wacht alstublieft terwijl we uw indiening ter goedkeuring bekijken.",
            returnHome: "Terug naar de startpagina",
        },
        dashboard: {
            dashboard: "Dashboard",
            requests: "Aanvragen",
            support: "Ondersteuning",
            claims: "Klachten",
            mes_demandes: "Mijn verzoeken",
            id: "ID",
            numero_entreprise: "Ondernemingsnummer",
            langue: "Taal",
            services: "Diensten",
            adresse: "Adres",
            dirigeants: "Bestuurders",
            cession_parts: "Overdracht van aandelen",
            date_creation: "Aanmaakdatum",
            actions: "Acties",
            voir_dossier: "Dossier bekijken",
            telecharger_dossier: "Dossier downloaden",


        },
        form: {
            title: 'Klachtenformulier',
            subtitle: 'Vul dit formulier in om uw klacht in te dienen',
            type: {
              label: 'Type klacht',
              placeholder: 'Selecteer een type klacht',
            },
            demande: {
              label: 'Aanvraag',
              placeholder: 'Selecteer een aanvraag',
            },
            description: {
              label: 'Beschrijving van het probleem',
              placeholder: 'Beschrijf uw probleem in detail...',
              remaining: 'tekens over',
            },
            contact: {
              title: 'Uw contactgegevens',
              name: 'Volledige naam',
              email: 'E-mail',
            },
            actions: {
              cancel: 'Annuleren',
              submit: 'Klacht verzenden',
              submitting: 'Bezig met verzenden...',
            },
            success: 'Uw klacht is succesvol verzonden! Een referentienummer wordt naar uw e-mail verzonden.',
        },
        table: {
            title: 'Mijn klachten',
            headers: {
              id: 'Id',
              type: 'Type',
              clientName: 'Klantnaam',
              demandeId: 'Aanvraag ID',
              email: 'E-mail',
              status: 'Status',
              date: 'Datum',
            },
            status: {
              cancelled: 'geannuleerd',
              resolved: 'opgelost',
              pending: 'in afwachting',
            },
        },
        generateTextIa: {
            title: "Tekstgenerator met IA",
            subtitle: "Genereer tekst met behulp van IA",
            loading: "Laden...",
            terminer: "Voltooien",
            label: "Bewerk de tekst indien nodig",
        }
    },
};
const savedLang = localStorage.getItem('lang') || 'fr';

const i18n = createI18n({
    locale: savedLang, // Langue par défaut
    fallbackLocale: 'fr',
    messages,
});

export default i18n;