import { defineStore } from 'pinia';
import axiosInstance from './axios';

export const useAuthStore = defineStore('auth', {
    state: () => ({
        user: null,
        isAdmin: false
    }),
    actions: {
        setUser(userData) {
            this.user = userData;
            this.isAdmin = userData.is_admin == true;
        },
        async checkAuthStatus() {
            try {
                const response = await axiosInstance.get('user');
                this.setUser(response.data);
            } catch (error) {
                this.clearUser();
            }
        },
        // ...
    }
});