import { createWebHistory, createRouter } from "vue-router";
import Login from "./auth/Login.vue";
import Register from "./auth/Register.vue";
import Step1 from "./steps/Step1.vue";
import Step2 from "./steps/Step2.vue";
import Step3 from "./steps/Step3.vue";
import Steps from "./steps/Steps.vue";
import Services from "./services/Services.vue";
import Dashboard from "./dashboard/Dashboard.vue";
import DashboardAdmin from "./dashboard/admin/Index.vue";
import ServicesAdmin from "./dashboard/admin/Services.vue";
import SupportAdmin from "./dashboard/admin/Support.vue";
import SettingsAdmin from "./dashboard/admin/Settings.vue";
import Step1Validate from "./steps/Step1Validate.vue";
import addrssService from "./services/AddrssService.vue";
import DirigeantsService from "./services/DirigeantsService.vue";
import CessionPartsService from "./services/CessionPartsService.vue";
import UpdateJson from "./updateJson.vue";
import Index from "./form/Index.vue";
import Formulaire1 from "./form/fr/Formulaire1.vue";
import FinishStep from "./steps/FinishStep.vue";
import { useAuthStore } from "./pinia.js";
import MyAssistance from "./dashboard/client/MyAssistance.vue";
import MesDemandes from "./dashboard/client/MesDemandes.vue";
import IndexClient from "./dashboard/client/Index.vue";
import CreateTicket from "./dashboard/client/CreateTicket.vue";
import Step4 from "./steps/Step4.vue";

const routes = [
    {
        path: "/",
        name: "steps",
        component: Steps,
        children: [
            {
                path: "/",
                name: "step1",
                component: Step1,
            },
            {
                path: "/step1Validate",
                name: "step1Validate",
                component: Step1Validate,
                // params: true,
            },
            {
                path: "/servicesStep",
                name: "servicesStep",
                component: Services,
            },
            {
                path: "/step2",
                name: "step2",
                component: Step2,
            },
            {
                path: "/step3",
                name: "step3",
                component: Step3,
            },
            {
                path: "/address_service",
                name: "addressService",
                component: addrssService,
            },
            {
                path: "/dirigeants_service",
                name: "dirigeantsService",
                component: DirigeantsService,
            },
            {
                path: "/cession_service",
                name: "cessionService",
                component: CessionPartsService,
            },
            {   path: "/step4",
                name: "step4",
                component: Step4,
            },
            
        ],
    },
    {
        path: "/login",
        name: "login",
        component: Login,
    },
    {
        path: "/register",
        name: "register",
        component: Register,
    },
    {
        path: "/dashboard",
        name: "dashboard",
        component: Dashboard,
        // alias: "/admin",
        children: [
            {
                path: "/admin",
                name: "admin",
                component: DashboardAdmin,
                meta: { requiresAdmin: true },
            },
            {
                path: "admin/services",
                name: "adminServices",
                component: ServicesAdmin,
                meta: { requiresAdmin: true },
            },
            {
                path: "admin/services",
                name: "adminSupport",
                component: SupportAdmin,
                meta: { requiresAdmin: true }
            },
            {
                path: "admin/settings",
                name: "adminSettings",
                component: SettingsAdmin,
                meta: { requiresAdmin: true }
            },
            {
                path: "/assistance",
                name: "assistance",
                component: MyAssistance,
            },
            {
                path: "/mes-demandes",
                name: "mesDemandes",
                component: MesDemandes,
            },
            {
                path: "/client",
                name: "client",
                component: IndexClient,
            },
            {
                path: "/create-reclamation",
                name: "createTicket",
                component: CreateTicket,
            },
        ],
    },
    {
        path: "/json",
        name: "json",
        component: UpdateJson,
    },
    {
        path: "/form?demande_id=:id",
        name: "form",
        component: Index,
        params:true
    },
    {
        path: "/finish",
        name: "finish",
        component: FinishStep,
    },
];

const router = createRouter({
    history: createWebHistory(),
    routes,
});

router.beforeEach((to, from, next) => {
    const publicRoutes = ["login", "register"];
    const isPublicRoute = publicRoutes.includes(to.name);
    const authStore = useAuthStore();

    if (!isPublicRoute && !localStorage.getItem("token")) {
        next({ name: "login" });
    } else if (isPublicRoute && localStorage.getItem("token")) {
        next({ name: "dashboard" });
    } else if (to.meta.requiresAdmin && !authStore.isAdmin) {

        next({ name: "login" });
    } else if (!authStore.user) {
        // next({name: "login"});
        next();
    } else {
        next();
    }
    // next();
});

export default router;
