<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\KboApiCallController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DemandeController;
use App\Http\Controllers\veriffController;
use App\Http\Controllers\SmsController;
use App\Http\Controllers\AddressServiceController;
use App\Http\Controllers\DirigeantsServiceController;
use App\Http\Controllers\ShareHolderController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\OpenAIController;

// Route::get('/user', function (Request $request) {
//     return $request->user();
// })->middleware('auth:sanctum');
Route::post('/getEnterpriseByNumber', [KboApiCallController::class, 'callApi'])->name('getEnterpriseByNumber');

// Auth routes
Route::post('login', [AuthController::class, 'login']);
Route::post('register', [AuthController::class, 'register']);
Route::post('logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');
Route::get('user', [AuthController::class, 'user'])->middleware('auth:sanctum');

// routes for demande 

Route::apiResource('demandes', DemandeController::class)->middleware('auth:sanctum');

// get demandes of auth user 
Route::get('/mydemandes',[DemandeController::class,'getMyDemandes'])->middleware('auth:sanctum');
Route::post('/user/language', [AuthController::class, 'updateLanguage'])->middleware('auth:sanctum');

// change the state of request
// routes/api.php
Route::post('/demandes/change_state/{demande_id}', [DemandeController::class, 'changeState'])
    ->middleware('auth:sanctum');

// routes for address service
Route::apiResource('addressService', AddressServiceController::class)->middleware('auth:sanctum');

// routes for dirigeants service
Route::apiResource('dirigeantsService', DirigeantsServiceController::class)->middleware('auth:sanctum');

// update the GSM and send the message :

Route::put('/updateGSM/{demande}',[DemandeController::class,'updateGSM'])->middleware('auth:sanctum');

Route::get('/send-sms', [SmsController::class, 'sendSms'])->name('send.sms');

// get auth user demandes
Route::get('/user-demandes', [DemandeController::class, 'userDemandes'])->middleware('auth:sanctum');


// routes for tickets
Route::apiResource('tickets', TicketController::class)->middleware('auth:sanctum');
// get tickets of auth user
Route::get('/mytickets',[TicketController::class,'getMyTickets'])->middleware('auth:sanctum');
// return the last 5 demandes
Route::get('/last-demandes', [DemandeController::class, 'lastDemandes'])->middleware('auth:sanctum');
// return the last 5 tickets
Route::get('/last-tickets', [TicketController::class, 'lastTickets'])->middleware('auth:sanctum');

// return the numbre of demandes and tickets and users
Route::get('/count', [DemandeController::class, 'count'])->middleware('auth:sanctum');
// return the numbre of demandes and tickets
Route::get('/count-client', [DemandeController::class, 'countClient'])->middleware('auth:sanctum');
//enregister text de publication 
Route::post('/demandes/{demande_id}/text', [DemandeController::class, 'storeText'])->middleware('auth:sanctum');
// get demnade avec share holders
Route::get('/demandes/{demande_id}/shareholders', [DemandeController::class, 'getWithSharesHolders'])->middleware('auth:sanctum');






Route::get('/veriff/session/{sessionId}/media', [VeriffController::class, 'getPersonMedia'])->name('veriff.person');
Route::get('/veriff/media/{mediaId}', [VeriffController::class, 'getMediaContent'])->name('veriff.person');

// shareholders route 
Route::apiResource('shareholders',ShareHolderController::class)->middleware('auth:sanctum');
// 767a4770-0398-4f42-ba73-1c7c52b4e0dd   Media Id 
// <img src="{{ url('/media/c59f4a31-e599-4680-b51b-bd153ba65d92') }}" alt="Selfie Video Frame" width="300">
// Route::get('/media/{mediaId}', 'MediaController@getMediaContent'); as a route 

Route::get('/getTextWithIA/{demandeId}', [OpenAIController::class, 'getChatCompletion']);