<?php

use App\Http\Controllers\gestionDesPdsController;
use App\Http\Controllers\KboApiCallController;
use App\Http\Middleware\VeriffMiddleware;
use Illuminate\Support\Facades\Route;
Route::prefix('/pdfs')->group(function(){
    Route::get('/', function () {return view('pdfs');})->name('pdfs');
    Route::controller(gestionDesPdsController::class)->group(
        function(){
            Route::get('/formulaire1', 'formulaire1')->name('formulaire1');
            Route::get('/formulaire2', 'formulaire2')->name('formulaire2');
        }
    );
});

Route::get('/{any}', function () {
    return view('welcome'); 
})->where('any', '.*');

Route::get('/', function () {
    return view('welcome');
});

//  http://your-app-url/getEnterpriseByNumber?langue=en&enterprise-number=12345


Route::post('/getEnterpriseByNumber', [KboApiCallController::class, 'callApi'])->name('getEnterpriseByNumber');


Route::get('/error', function () {return view('error');})->name('error');
Route::get('/pdfs', function () {return view('pdfs');})->name('pdfs');

// Route::prefix('/pdfs')->middleware(VeriffMiddleware::class)->group(function(){
//     Route::get('/', function () {return view('pdfs');})->name('pdfs');
//     Route::controller(gestionDesPdsController::class)->group(
//         function(){
//             Route::get('/formulaire1', 'formulaire1')->name('formulaire1');
//             Route::get('/formulaire2', 'formulaire2')->name('formulaire2');
//         }
//     );
// });


use App\Http\Controllers\VeriffController;

// Route::get('/veriff/upload-page', [VeriffController::class, 'upload'])->name('veriff.upload');
Route::get('/veriff/upload', [VeriffController::class, 'upload'])->name('veriff.upload');

Route::post('/veriff/session', [VeriffController::class, 'createSession'])->name('veriff.session');
Route::get('/veriff/session/{sessionId}', [VeriffController::class, 'getSessionStatus'])->name('veriff.status');
Route::get('/veriff/callback', [VeriffController::class, 'handleCallback'])->name('veriff.callback');
Route::get('/veriff/session/{sessionId}/person', [VeriffController::class, 'getPersonData'])->name('veriff.person');
Route::get('/veriff/not-found', [VeriffController::class, 'notFoundPage'])->name('veriff.not_found');
Route::get('/veriff/verification_declined', [VeriffController::class, 'veriffDeclinedPage'])->name('veriff.veriff_declined');
Route::get('/veriff/error_page', [VeriffController::class, 'errorPage'])->name('veriff.error_page');
// Routes for veriff
Route::prefix('/veriff')->controller(VeriffController::class)->group(function(){
    Route::get('/upload','upload')->name('veriff.upload');
    Route::post('/session','createSession')->name('veriff.session');
    Route::get('/session/{sessionId}',  'getSessionStatus')->name('veriff.status');
    Route::get('/callback', 'handleCallback')->name('veriff.callback');
    Route::get('/session/{sessionId}/person','getPersonData')->name('veriff.person');
    Route::get('/session/{sessionId}/d','getDecision')->name('veriff.person');
    Route::get('/not-found','notFoundPage')->name('veriff.not_found');
    Route::get('/verification_declined','veriffDeclinedPage')->name('veriff.veriff_declined');
    Route::get('/error_page', 'errorPage')->name('veriff.error_page');
});


